
# couponsHarm.py

# simulate coupon collector's problem
# https://en.wikipedia.org/wiki/Coupon_collector%27s_problem

import random
import matplotlib.pyplot as plt
from coupons import *

MAX_COUPONS = 100
NUM_TESTS = 100

def harmonicNum(n):
  return sum([(1/i) for i in range(1, n+1)])

ns = range(MAX_COUPONS)
ys = [0]*MAX_COUPONS
hs = [0]*MAX_COUPONS

for n in ns:
  tot = 0
  for x in range(NUM_TESTS):
    tot += collect(n)
  ys[n] = tot / NUM_TESTS
  hs[n] = n * harmonicNum(n)

plt.xlabel('No. Coupons')
plt.ylabel('No. Spins')
plt.plot(ns, ys, 'b', alpha = 0.8, label="Expected")
plt.plot(ns, hs, 'r', label="Harmonic curve")
plt.legend()
plt.title('Coupon Collection and the Harmonic Curve')
plt.show()
