
# largeFlips.py
'''
   Perform 100 tests, ranging from
   2^4 to 2^20 flips. Record two things:
   the final head/tail ratio and  final
   (no. heads - no. tails). Plot as two
   graphs.
'''

import random
import matplotlib.pyplot as plt
from frange import *

MIN = 4
MAX = 20

# Plots results of 2**MIN to 2**MAX coin flips
# in steps of 100
ratios, diffs, xs = [], [], []
for i in linspace(MIN, MAX, 100):
  xs.append(int(2**i))
for numFlips in xs:
  flips = random.choices(['H', 'T'], k=numFlips)
  numHeads = flips.count('H')
  numTails = numFlips - numHeads
  try:
    ratios.append(numHeads/numTails)
    diffs.append(abs(numHeads - numTails))
  except ZeroDivisionError:
    continue
print("Final abs diff:", diffs[-1])
print("Final ratio:", ratios[-1])

fig, ax = plt.subplots(1, 2, figsize=(12, 4))

ax[0].set_title('Heads & Tails Ratios')
ax[0].set_xlabel('Coin Tosses')
ax[0].set_ylabel('Heads/Tails')
ax[0].plot(xs, ratios, marker='o', ms=2, lw=1)
ax[0].set_xscale('log')

ax[1].set_title('Heads & Tails Diffs')
ax[1].set_xlabel('Coin Tosses')
ax[1].set_ylabel('|Heads - Tails|')
ax[1].plot(xs, diffs, marker='o', ms=2, lw=1)
ax[1].set_xscale('log')
ax[1].set_yscale('log')


plt.show()




