
# headsDiffs.py
'''
  Over MAX_FLIPS flips, record cummulative
  no. heads > no.tails 
  as a positive or negative number, then plot it.
'''

import random
import math
import matplotlib.pyplot as plt

MAX_FLIPS = 10**6

hDiff = 0   # no of heads > no of tails
posCount = 0    # no. of times diff is +ve
negCount = 0    # no. of times diff is -ve

diffs = [] 
for j in range(MAX_FLIPS):
  flip = random.choice(['H', 'T'])
  if flip == 'H':
    hDiff += 1
  else:
    hDiff -= 1 
  if hDiff > 0:
    posCount += 1
  else:
    negCount += 1
  diffs.append(hDiff)

print("Final heads > tails diff:", diffs[-1])
print("% Times that Heads > Tails:")
print(f"  Pos: {(posCount/MAX_FLIPS):.2%}; Neg: {(negCount/MAX_FLIPS):.2%}")

plt.plot(diffs)
plt.title("Heads > Tails")
plt.xlabel("Coin Tosses")
plt.ylabel("Head > Tail Diff")
plt.axhline(y=0, color='k')

plt.show()
