
# frange.py
# https://stackoverflow.com/questions/7267226/range-for-floats

from fractions import Fraction

def frange(start, stop, jump, end=False, via_str=False):
  """
  Equivalent of Python 3 range for decimal numbers.

  Due to arithmetic errors, it is safest to
  pass the arguments as strings, so they can be interpreted to exact fractions. Parameter `via_str` can be set to True to transform inputs in strings and then to fractions.
  """
  if via_str:
    start = str(start)
    stop = str(stop)
    jump = str(jump)

  start = Fraction(start)
  stop = Fraction(stop)
  jump = Fraction(jump)

  while start < stop:
    yield float(start)
    start += jump

  if end and start == stop:
    yield(float(start))


def linspace(start, stop, num=50, endpoint=True):
  # so I don't need numpy linspace
  vals = []
  if endpoint:
    step = (stop - start)/(num-1)
  else:
    step = (stop - start)/num
  for i in range(num):
    vals.append(start + (step * i))
  return vals


