
# flipHist.py
# input: 100  or  1000
''' 
  NUM _TRIALS tests of of flips
  where the number of heads is recorded. Plot
  a histogram of all the results.
'''

import matplotlib.pyplot as plt
import random, statistics

NUM_TRIALS = 10000

nf = int(input("no. flips? "))

hs = [0]*NUM_TRIALS
for i in range(NUM_TRIALS):
  flips = random.choices(['H', 'T'], k=nf)
  hs[i] = flips.count('H')


m = statistics.mean(hs)
std = statistics.stdev(hs)
print(f"Mean = {m:.1f}; Stdev = {std:.2f}")

ax = plt.gca()
plt.text(0.7, 0.7, f"Mean = {m:.1f}\n" +
                   f"Stdev = {std:.2f}", 
   bbox={'facecolor': 'white'}, transform=ax.transAxes)

bins = [i-0.5 for i in range(nf+2)]
plt.hist(hs, bins)
plt.xlabel("No. of heads")
plt.ylabel('Counts')
plt.title("No. of heads in " + str(nf) + " flips")
plt.show()
