
# countPairs.py
'''
  TH is more likely than not to be the 
  first of TH and HH to occur if coin tossing 
  continues until one or the other occurs. 
'''

import random
import math

NUM_TRIALS = 10**5

thCount = 0
hhCount = 0
cnts = [] 
for j in range(NUM_TRIALS):
  prevFlip = random.choice(['H', 'T'])
  while True:
    flip = random.choice(['H', 'T'])
    if prevFlip == 'T' and flip == 'H':
      thCount += 1
      break
    elif prevFlip == 'H' and flip == 'H':
      hhCount += 1
      break
    else:
      prevFlip = flip
print(f"TH%: {(thCount/NUM_TRIALS):.2%}; HH%: {(hhCount/NUM_TRIALS):.2%}")
