# lonesome 
# Fig. 37.1 

import random

NUM_TRIALS = 10000
NUM_PEOPLE = 10

def makeFriends(i):
  # generate two indicies different from i
  # and set friends[]
  r = i
  while r == i:
    r = random.randint(0,NUM_PEOPLE-1)
  s = i
  while (s == i) or (r == s):
    s = random.randint(0,NUM_PEOPLE-1)
  friends[r] = True
  friends[s] = True

numNotLone = 0
totLone = 0
friends = [False]*NUM_PEOPLE
for _ in range(NUM_TRIALS): 
  numLone = 0
  for i in range(NUM_PEOPLE): 
    friends[i] = False
  for i in range(NUM_PEOPLE): 
    makeFriends(i)
  for i in range(NUM_PEOPLE): 
    if not friends[i]: # look for lonely people
      numLone += 1
  totLone += numLone
  if numLone == 0: 
    numNotLone += 1 # increment if no lonely people
print("Not Lonesome =", numNotLone, "; Lonesome =", totLone)
print(f"Prob Not Lonesome = {numNotLone/NUM_TRIALS:.4f}")
print(f"Expected No. Lonesome = {totLone/NUM_TRIALS:.4f}")

