# Anchuria 
# Fig. 36.2 

import random

NUM_ANGLERS = 100000
MAX_FISH = 20

catchFreq = [0]*(MAX_FISH+1)
totFish = 0
for i in range(NUM_ANGLERS): 
  prec = random.random() 
  next = random.random() 
  numFish = 2  # always catch at least two
  while prec >= next: 
    prec = next
    next = random.random() 
    numFish += 1
  catchFreq[numFish] += 1
  totFish += numFish

print("  n      p        q    ")
q = 1
for i in range(2,MAX_FISH+1):
  if catchFreq[i] > 0: 
    p = catchFreq[i]/NUM_ANGLERS
    q -= p
    print(f"{i:3} {p:9.5f} {q:9.5f}")
print(f"E = {totFish/NUM_ANGLERS:.5f}")
