# leftTail.py
# Fig. 35.3 
# inputs: 818 411 181 76

import math
import decimal
from decimal import Decimal as D


def h(n, r, s, x):
  rs = math.comb(r, x)
  nrsx = math.comb(n-r, s-x)
  ns = math.comb(n, s)
  return (rs * nrsx)/ns

def hSum(n, r, s, x):
  return sum([h(n, r, s, i) for i in range(x+1)])

def hD(n, r, s, x):
  dn = D(n); dr = D(r)
  ds = D(s); dx = D(x)
  h0 = D(1)
  for i in range(1, s+1):
    h0 *= (dn-dr-i+1)/(dn-i+1)
  hn = h0
  for i in range(1,x+1): 
    hn *= ((dr-i+1)*(ds-i+1))/(i*(dn-dr-ds+i))
  return hn

def hSumD(n, r, s, x):
  sum = D(0)
  for i in range(x+1):
    sum += hD(n, r, s, i)
  return sum


if __name__ == "__main__":
  n,r,s,x = map(int, input("n r s x=? ").split())
  p = hSum(n, r, s, x)
  pD = hSumD(n, r, s, x)
  print(" p =", p)
  print("pd =", pD)
