
# quincunx.py
# https://en.wikipedia.org/wiki/Galton_board
# input: 300

import math, random
import matplotlib.pyplot as plt 

NUM_BUCKETS = 30  # make even

n = int(input("n=? "))
counts = [0]*NUM_BUCKETS
for i in range(n):
  pos = NUM_BUCKETS//2
  for row in range(NUM_BUCKETS):
    toss = random.choice(["h", "t"])
    if toss == "h":
      if pos > 0:
        pos -= 0.5
    else:
      if pos < NUM_BUCKETS-1:
        pos += 0.5
  counts[round(pos)] += 1

plt.bar(range(NUM_BUCKETS), counts) 
plt.xlabel("buckets")
plt.ylabel("counts")
plt.title("Quincunx; n="+str(n))
plt.show()