
# reader.py

def readVals(fnm):
  with open(fnm) as file:
    for line in file:
       if not line.startswith("# "):
         for value in line.split():
            yield value


def readInt(rdr):
  return int(next(rdr))

def readFloat(rdr):
  return float(next(rdr))

def readString(rdr):
  return next(rdr)

def readInt1D(rdr):
  count = int(next(rdr))
  vals = []
  for i in range(count):
    vals.append( int(next(rdr)))
  return vals

def readFloat1D(rdr):
  count = int(next(rdr))
  vals = []
  for i in range(count):
    vals.append( float(next(rdr)))
  return vals


def readInt2D(rdr):
  numRows = int(next(rdr))
  numCols = int(next(rdr))
  # vals[x][y]
  vals = [[0.0 for y in range(numCols)] for x in range(numRows)]
  for r in range(numRows):
    for c in range(numCols):
      vals[r][c] = int(next(rdr))
  return vals

def readFloat2D(rdr):
  numRows = int(next(rdr))
  numCols = int(next(rdr))
  # vals[x][y]
  vals = [[0.0 for y in range(numCols)] for x in range(numRows)]
  for r in range(numRows):
    for c in range(numCols):
      vals[r][c] = float(next(rdr))
  return vals
