# kendallit 
# Fig. 33.4 
# inputs: 9 6 or 12 11

import math

def numDiscs(n,k):
  # numDiscs[i][j]
  nds = [[0 for j in range(k+1)] for i in range(n+1)]
  for i in range(1,n+1):
    nds[i][0] = 1
  for j in range(k+1):
    nds[1][j] = 1
  
  for i in range(2,n+1):
    for j in range(1,k+1):
      if j < i:
        nds[i][j] = nds[i][j-1] + nds[i-1][j]
      else:
        nds[i][j] = nds[i][j-1] + nds[i-1][j] - \
                         nds[i-1][j-i]
  return nds[n][k]


n,k = map(int, input("n k=? ").split())
nd = numDiscs(n,k)
numPerms = math.factorial(n)
print("no. discordants =", nd)
print(f"p = {(nd/numPerms):.5f}")
