
# corrCoef.py

import math, statistics
from reader import *


def dot(xs, ys):
  return sum([x*y for x, y in zip(xs, ys, strict=True)])

def corrCoef(xs, ys):
  # Assume len(xs) == len(ys)
  n = len(xs)
  xSum = sum(xs)
  ySum = sum(ys)
  xSum2 = sum([x*x for x in xs])
  ySum2 = sum([y*y for y in ys])
  xys = dot(xs, ys)
  numer = n*xys - xSum*ySum
  denom = math.sqrt((n*xSum2 - xSum*xSum) * (n*ySum2 - ySum*ySum))
  if denom == 0: 
    return 0
  return numer/denom


if __name__ == "__main__":
  rdr = readVals("cc1.txt")
  xs = readFloat1D(rdr)
  ys = readFloat1D(rdr)
  print(corrCoef(xs, ys))   # 0.647551
  print(statistics.correlation(xs, ys))   # 0.647551