
# readDraft.py

'''
https://en.wikipedia.org/wiki/Draft_lottery_(1969)
https://web.archive.org/web/20050318170452/http://cnx.rice.edu/content/m10142/latest/
'''

import math, csv


def loadDict(fnm):
  pres = []
  print("Loading:", fnm)
  with open(fnm, mode ='r') as file:
    csvFile = csv.DictReader(file)
    for dict in csvFile:
      pres.append(dict)
  return pres


def toInt(s):
  try:
    return int(s)
  except ValueError:
    print(f"No value for '{s}'")
    return 0


draftDicts = loadDict('draft.csv')
print("Keys:", list(draftDicts[0].keys()))
print("No. of records:", len(draftDicts))
# print(draftDicts)

junes = [toInt(d['Jun']) for d in draftDicts]
print("June:", junes)