
# readPres2.py

'''
  https://potus.com/presidential-facts/presidents-age-at-death/
  https://potus.com/presidential-facts/presidential-heights/
'''

import math, csv
import matplotlib.pyplot as plt


def loadDict(fnm):
  pres = []
  print("Loading:", fnm)
  with open(fnm, mode ='r') as file:
    csvFile = csv.DictReader(file)
    for dict in csvFile:
      pres.append(dict)
  return pres


presDicts = loadDict('presidents.csv')

ages = [int(d["Age"]) for d in presDicts]
maxAge = max(ages)
print("Max age:", maxAge)

shortsAges = []
tallsAges = []
for d in presDicts:
  if int(d["Height"]) < 173:
    shortsAges.append( maxAge - int(d["Age"]))
  else:
    tallsAges.append( maxAge - int(d["Age"]))

shortsAges.sort()
tallsAges.sort()
print("Short Ages:", shortsAges)
print("Tall Ages:", tallsAges)
