
# readPresidents.py

'''
  https://potus.com/presidential-facts/presidents-age-at-death/
  https://potus.com/presidential-facts/presidential-heights/
'''

import math, csv
import matplotlib.pyplot as plt


def stemLeaf(title, nums, low, high):
  d = {k:[] for k in range(low, high+1)}
  nums.sort()
  for num in nums:
    frac, whole = math.modf(num)
    d[int(whole)].append(int(round(frac*10)))
  print(title)
  print("stem   leaf")
  for key in d.keys():
    print(f"{key:4d} |", ''.join(str(x) for x in d[key]))


def loadDict(fnm):
  pres = []
  print("Loading:", fnm)
  with open(fnm, mode ='r') as file:
    csvFile = csv.DictReader(file)
    for dict in csvFile:
      pres.append(dict)
  return pres


presDicts = loadDict('presidents.csv')
print("Keys:", list(presDicts[0].keys()))
print("No. of records:", len(presDicts))
# print(presDicts)

print()
ages10 = [int(d["Age"])/10 for d in presDicts]
stemLeaf("Presidential Ages", ages10, 5, 9)

# extract age infiormation
agesNos = [(int(d["Age"]), int(d["No"])) for d in presDicts]
agesNos.sort(key=lambda tup: tup[0])
# print("Ages/Nos:", agesNos)

shortsAges = []
tallsAges = []
tallsAgesNos = []
for d in presDicts:
  if int(d["Height"]) < 173:
    shortsAges.append( int(d["Age"]))
  else:
    tallsAges.append( int(d["Age"]))
    tallsAgesNos.append( (int(d["Age"]), int(d["No"])) )

shortsAges.sort()
tallsAges.sort()
print()
print("Short Ages:", shortsAges)
print("Tall Ages:", tallsAges)

tallsAgesNos.sort(key=lambda tup: tup[0])
# print("tallsAgesNos:", tallsAgesNos)

print("\nAges as binary:")
wsShorts = [1]*len(agesNos)
for tan in tallsAgesNos:
  i = 0
  for an in agesNos:
    if tan == an:
      break
    i += 1
  wsShorts[i] = 0
ws = ''.join(str(w) for w in wsShorts)
print(len(ws), ":", ws)

print("Short Positions (from 1):")
shortSum = 0
for i in range(len(wsShorts)):
  if wsShorts[i] == 1:
    print((i+1), end=' ')
    shortSum += (i+1)
print()
print("Rank sum:", shortSum)


# plot ages of two groups
plt.boxplot([tallsAges, shortsAges])
plt.xticks([1, 2], ['tall', 'short'])
plt.ylabel("Ages")
plt.grid(axis="y")
plt.title("Ages of tall and short Presidents")
plt.show()