
# permSimStats.py 
# input: marijuana.txt

import random, math
from reader import *
from collections import defaultdict

NUM_REPEATS = 24
NUM_TRIALS = 32000

def stemLeaf(nums):
  d = {k:[] for k in range(3)}
  nums.sort()
  for num in nums:
    frac, whole = math.modf(num)
    d[whole].append(int(frac*10))
  print("stem   leaf")
  for key in d.keys():
    print(f"{key:4d} |", ''.join(str(x) for x in d[key]))


def sample(vals, s):
  samps = []
  n = len(vals)
  i = 0
  while n > 0:
    if random.randint(0, n-1) < s: 
      s -= 1
      samps.append( vals[i])
    i += 1
    n -= 1
  return samps


fnm = input("fnm? ")
table = readInt2D(readVals(fnm))
xSum = sum(table[0])
ySum = sum(table[1])
print("x, y sums:", xSum, ySum)
vals = []
for row in table:
  vals.extend(row)

sampSize = len(table[1])
ps = []
for i in range(NUM_REPEATS):
  count = 0
  for j in range(NUM_TRIALS): 
    samp = sample(vals, sampSize)
    if sum(samp) >= xSum:
      count += 1
  p = count*100/NUM_TRIALS
  # print(f"count == {count}; P == {p:.6f}")
  ps.append(p)

print(ps)
stemLeaf(ps)
