
# permSim.py 
# input: marijuana.txt

import random
from reader import *
from collections import defaultdict

NUM_TRIALS = 32000

def sample(vals, s):
  samps = []
  n = len(vals)
  i = 0
  while n > 0:
    if random.randint(0, n-1) < s: 
      s -= 1
      samps.append( vals[i])
    i += 1
    n -= 1
  return samps

fnm = input("fnm? ")
table = readInt2D(readVals(fnm))
xSum = sum(table[0])
ySum = sum(table[1])
print("x, y sums:", xSum, ySum)
vals = []
for row in table:
  vals.extend(row)
count = 0
sampSize = len(table[1])
for j in range(NUM_TRIALS): 
  samp = sample(vals, sampSize)
  if sum(samp) >= xSum:
    count += 1
print(f"count == {count}; P == {count/NUM_TRIALS:.6f}")
