
# subsTimer.py

from sumSubsets import *
import math, timeit
import matplotlib.pyplot as plt

NUM_ITERS = 100
TOT = 8

def timer(fn, iters):
  t = timeit.timeit(fn+"(nums, TOT)", 
            globals=globals(), number=iters)
  return t

numbs = [[1]*r for r in range(1,20)]  # 15, 20
ns = [] 
dr = []; dd = []; dc = []
for nums in numbs:
  ns.append(len(nums))
  dr.append( timer('sumSubsetsR', NUM_ITERS))
  dd.append( timer('sumSubsetsD', NUM_ITERS))
  dc.append( timer('sumSubsetsC', NUM_ITERS))

plt.plot(ns, dr, label="Recursive")
plt.plot(ns, dd, label="Dict",ls=':')
plt.plot(ns, dc, label="Itertools", ls='--')

plt.legend()
plt.xlabel("list length")
plt.ylabel("secs")
plt.title('Times for subset sums')

plt.show()
