
# cycle2.py
# based on fcycle.py 

import random

def trans(xs):
  n = len(xs)
  t = xs[0]
  for i in range(n-1):
    xs[i] = xs[i] ^ xs[i+1] 
  xs[n-1] = xs[n-1] ^ t


def findCycle(start):
  slow = start.copy()
  fast = start.copy()

  catchup = 0; cycleLen = 0
  tailLen = 0
  # let fast catch up to slow
  while True:
    trans(slow)
    trans(fast); trans(fast)
    catchup += 1
    cycleLen += 1
    if slow == fast:
      break
  
  if slow == start:  # there's no tail
    print("pure cycle")
  else:  # slow is sent once more round cycle
    cycleLen = 0
    while True:
      trans(slow)
      cycleLen += 1
      if slow == fast:
        break
    # finished calculating cycle len

    # set fast back to start to calculate tail
    fast = start.copy()
    tailLen = 0
    while True:
      trans(fast)
      trans(slow)
      tailLen += 1
      if fast == slow:
        break
  return catchup, cycleLen, tailLen


n = int(input("n=? "))
xs = [random.randint(0,1) for i in range(n)]
k, c, t = findCycle(xs)
print("Catchup:", k, "; Cycle len:", c, "; Tail len:", t)
