
# randpts.py

"""
  What is a random point in a circle?

  Paul Nahin,
  Digital Dice: Computational Solutions to Practical Probability Problems,
  Princeton, 2008,
  Intro p.16
"""


import math, random
import matplotlib.pyplot as plt


def randomRect():
  while True:
    x = random.uniform(-1, 1)
    y = random.uniform(-1, 1) 
    if (x*x)+(y*y) <= 1:
      return (x,y)



def randomPolar(useSqrt):
  angle = 2*math.pi * random.random()
  if useSqrt:
    radius = math.sqrt(random.random())
  else:
    radius = random.random()  # poorly distributed

  x = radius * math.cos(angle) + 0.5
  y = radius * math.sin(angle) + 0.5
  return (x,y)


# create random data
n = 1000

xs = []
ys = []
for i in range(n):
  # coord = randomRect()
  coord = randomPolar(useSqrt=True)
  xs.append(coord[0])
  ys.append(coord[1])

plt.scatter(xs, ys, s=10)
plt.axis('scaled')
plt.title("Random coordinates") 
plt.show()


