
# prngTest.py

'''
Dive into Algorithms
Bradford Tuckfield
No Starch Press, 2021
Ch. 5

One of the Diehard tests, called the overlapping sums test, takes a list of random numbers and finds sums of sections of consecutive numbers from the list. The collection
of all these sums should follow  a bell curve.
'''

import random
import matplotlib.pyplot as plt

def overlappingSums(vals, sumLength):
  leng = len(vals)
  vals.extend(vals)
  sums = []
  for n in range(leng):
    tot = sum( vals[n:(n + sumLength)] )
    sums.append(tot)
  return sums

rands = [random.random() for i in range(10000)]

sums = overlappingSums(rands, 12)
plt.hist(sums, 20, facecolor = 'blue')

plt.title('Overlapping Sums Test')
plt.xlabel('Sum of Elements')
plt.ylabel('Frequency of Sum')
plt.show()


