# lehmer.py
# Display a histogram of nums generated by the Lehmer PRNG.

import random
from datetime import datetime
import matplotlib.pyplot as plt

n = 10000
MOD = 2**31 - 1   # a prime number 
CONST = 16807     # an integer between 1 and MOD-1

def lehmer(r):
  # Compute pseudo-random number using a Lehmer PRNG
  return (CONST * r) % MOD

def randomSeq(n, seed):
  r = seed
  rands = []
  for i in range(n):
    # r = lehmer(r)
    r = random.random()
    rands.append(r)
  return rands

seed = datetime.now().timestamp()
print("seed:", seed)
samples = randomSeq(n, seed)
plt.hist(samples, 100)
plt.xlabel("Random value")
plt.ylabel("Count")
plt.show()
