
# lattice.py

'''
  Challenging Programming in Python
  Habib Izadkhah, Rashid Behzadidoost
  Springer, 2024
  Code 3.2

x, y, blocks 			Expected output
3, 2, []				10
1, 6, [(7, 1), (4, 4)]	7
8, 8, [(9, 10), (1, 4)]	11220
7, 5, [6,8]				792
'''

blocks = [(9, 10), (1, 4)]


def latticePaths(row, col, blocks):
  paths = [[0]*(col+1) for _ in range(row+1)]

  # Set value of top-left corner cell
  paths[0][0] = 1

  # Fill in the first column of the table
  for i in range(1, row+ 1):
    if (i, 0) not in blocks:
      paths[i][0] = paths[i-1][0]

  # Fill in the first row of the table
  for j in range(1, col+1):
    if (0, j) not in blocks:
      paths[0][j] = paths[0][j-1]

  # Fill in the rest of the table
  for i in range(1, row+1):
    for j in range(1, col+1):
      if (i, j) not in blocks:
        ''' The value of each non-border cell
            is the sum of the value of the cell
            above it and the cell to the left of it.
        '''
        paths[i][j] = paths[i-1][j] + paths[i][j-1]

  return paths[row][col]


# ------ main ----------
x, y = map(int, input("x y? ").split())
print( latticePaths(x, y, blocks))
