
# goldbachComet.py
# https://en.wikipedia.org/wiki/Goldbach%27s_conjecture
# https://en.wikipedia.org/wiki/Goldbach%27s_comet
'''
Every even integer greater than 2 can be written as the sum of two primes.

plot of the function goldback(g)

The coloring of points is based on the value of g/2 modulo 3 with red points corresponding to 0 mod 3, green points corresponding to 1 mod 3 and blue points corresponding to 2 mod 3. 

In other words, the red points are multiples of 6, the green points are multiples of 6 plus 2, and the blue points are multiples of 6 plus 4. 
'''

import math
import matplotlib.pyplot as plt
from prime import *

MAX = 5000

def goldback(g):
  x = 3
  count = 0
  while x <= g-x:
    if isPrime(x):
      if isPrime(g-x):
        count += 1
    x += 2
  return count

gR = []; csRed = []
gG = []; csGreen = []
gB = []; csBlue = []
for g in range(6, MAX, 2):  # g is even
  count =  goldback(g)
  if count > 0:
    if (g/2)%3 == 0:
      gR.append(g)
      csRed.append(count)
    elif (g/2)%3 == 1:
      gG.append(g)
      csGreen.append(count)
    else: 
      gB.append(g)
      csBlue.append(count)

plt.scatter(gR, csRed, marker='+', c='r', s=14, 
                label='x%3==0', alpha=0.5)
plt.scatter(gG, csGreen, marker='1', c='k', s=14, 
                label='x%3==1', alpha=0.5)
plt.scatter(gB, csBlue, marker='x', c='b', s=14, 
                label='x%3==2', alpha=0.5)
plt.xlabel("x")
plt.ylabel("counts")
plt.legend()
plt.title("Goldback's Comet")
plt.show()

