# goldbach.py
# Fig. 17.7 
# input: 200 or 202 or 204 or 206
# https://en.wikipedia.org/wiki/Goldbach%27s_conjecture

import math
from prime import *

def goldbackFull(g):
  x = 3
  count = 0
  while x <= g-x:
    if isPrime(x):
      if isPrime(g-x): 
        print(f"  {x}+{g-x}", end='')
        count += 1
    x += 2
  print()
  return count

if __name__ == "__main__":
  a, b = map(int, input("a b? ").split()) 
  for g in range(a, b+1, 2):
    print("-----", g, "-----")
    print(" Count:", goldbackFull(g))
    print(f"Expect: {g/(2*(math.log(g)**2)):.1f}")
    print()
