
# superprimes.py
# input: 241

'''
A SUPERPRIME is an integer such is
prime and every integer obtained by deleting a digit from
the right is a prime. 

E.g., 7331 is prime, 733 is prime, 73 is
prime, and 7 is prime. Thus 7331 is a superprime.

What 2- and 3-digit superprimes exist?

Which digits of a superprime can be a 1, 2. 4, 5, 6, 8, and
0?
'''

import math
from prime import *

def isSuperPrime(n, prims):
  nStr = str(n)
  for i in range( len(nStr), 0, -1):
    if not prims[int(nStr[:i])]:
      return False
  return True


# ---------- main -----------

n = 10000
prims = sievePrimes(n)

for i in range(10, n):
  if isSuperPrime(i, prims):
    print(i, end = ' ')
print()
