
# FermatNumbers.py
# input: 5 or 10 or 20
'''
A Fermat number is a positive integer of the form:
     2^(2^k) + 1

The first few Fermat numbers:
   3, 5, 17, 257, 65537, 4294967297, 18446744073709551617

https://en.wikipedia.org/wiki/Fermat_number
'''

import math
import sys

def fermat(n):
  return int(math.pow(2, math.pow(2, n))) + 1

def fermat2(n):
  # to avoid math range error
  return 2**(2**n) + 1


if __name__ == "__main__":
  sys.set_int_max_str_digits(0)  
  # avoids integer string conversion limit
  n = int(input("n? "))
  for i in range(n):
    print(f"2^{i}+1 = {fermat2(i)}")
