
# calkinwilf.py
'''
The Calkin-Wilf tree is a rooted binary tree whose vertices are in one-to-one correspondence with the positive rational numbers. 

The root of the tree corresponds to the number 1, and for any rational number a/b, its left child corresponds to the number a/(a+b) and its right child corresponds to the number (a+b)/b. 

Each rational number appears exactly once in the tree. 

The function takes a positive integer n as input and retums the n-th term of the Calkin-Wilf sequence. 

  n 		Expected output
  11 		5/2
  2022 		32/45
  1993 		59/43
  24 		2/7
  10 		3/5
'''


def nCalkinWilf(n):
  queue =[(1,1)]
  n -= 1
  for _ in range(n):
    numer, denom = queue.pop(0)
    # Compute the left and right children
    leftNumer = numer
    leftDenom = numer + denom
    rightNumer = numer + denom
    rightDenom = denom
    queue.append((leftNumer, leftDenom))
    queue.append((rightNumer, rightDenom))
  # Dequeue the final node
  finalNumer, finalDenom = queue.pop(0)
  if finalDenom == 1:
    return finalNumer
  else:
    return str(finalNumer) + '/' + str(finalDenom)

n = int(input("n? "))
print( nCalkinWilf(n))
