
# ncFibs.py

'''
  According to Zeckendorf’s theorem, any arbitrary positive integer can be expressed as a sum of distinct non-consecutive Fibonacci numbers in a unique manner. 

  Write a function that takes a positive integer n as input and returns a list of non-consecutive Fibonacci numbers which add up to n. 

  The list must be in descending order. The expected outputs for certain inputs are illustrated below:

  n		    Sum
  53		[34, 13, 5, 1]
  25		[21, 3, 1]
  31		[21, 8, 2]
  3009	 	[2584, 377, 34, 13, 1]
'''

from fibsLib import *


def fibsSum(n):
  fibVals = fibs(n)
  fibVals.sort(reverse=True)

  usedFibs = []
  sum = 0
  for num in fibVals:
    if sum + num <= n:
      usedFibs.append(num)
      sum += num
      if sum == n:
        return usedFibs


# ------ main ----------
n = int(input("n? "))
print( fibsSum(n))
