
# factsum.py

'''
Factorial Sum List

Given a number, calculate the sum of the factorials of its 
digits. Repeat with the new number. Stop when a repetition occurs. 

e.g.: 25 -> 122 -> 5 -> 120 -> 4 -> 24 -> 26 -> 722 -> 
      5044 -> 169 -> 3636001 -> 1454 -> 169.

# info: https://en.wikipedia.org/wiki/Factorion
'''

import math


def factSum(n):
 return sum( [math.factorial(int(d)) for d in str(n)])


def collectSums(n):
  return colSums(n, [n])

def colSums(n, sums):
  fs = factSum(n)
  if fs in sums:
    sums.append(fs)
    return sums
  else:
    sums.append(fs)
    return colSums(fs, sums)
    

# -------------------------------
# n = int(input("n=? "))
# sums = collectSums(n)
# print("Sums length:", len(sums))

if __name__ == "__main__":
  counts = dict()
  for i in range(1, 1000):
    sums = collectSums(i)
    repeatVal = sums[-1]
    counts[repeatVal] = counts.get(repeatVal, 0) + 1
  
  print("\nRepeat Counts 1-999:")
  for key in sorted(counts):
      print(f"{key:7d}: {counts[key]}")
