
# dragon-q17
# Sections 1-5, Q.17, p.13
# inputs: 128 or 512 or 1024
# info: https://en.wikipedia.org/wiki/Regular_paperfolding_sequence
# info https://en.wikipedia.org/wiki/Dragon_curve

from turtle import Turtle

STEP = 10

def a(n):
  if n%4 == 1:
    return 1
  elif n%4 == 3:
    return 0
  else:
    return a(n/2)


def draw(t, seq):
  for x in seq:
    if x == 0:
      t.right(90)
      t.forward(STEP)
    else:  # 1
      t.left(90)
      t.forward(STEP)



n = int(input("n=? "))

seq = [0]*(n+1)
for i in range(1, n+1):
  seq[i] = a(i)

print(*seq[1:], sep='')

# Turtle setup
t = Turtle()
t.speed(0)
t.hideturtle()

scr = t.getscreen()
scr.title("Dragon Curve")
scr.screensize(300, 300)

draw(t, seq)
scr.exitonclick()


