
# catalan.py
# find the nth catalan number
# info: https://en.wikipedia.org/wiki/Catalan_number
#       https://maa.org/meetings/calendar-events/a-surreptitious-sequence-the-catalan-numbers

import math


def catalan(n):
  if n <= 1:
    return 1
  else:
    res = 0
    for i in range(n):
      res += catalan(i) * catalan(n-i-1)
    return res


def catalanComb(n):
  return math.comb(2*n, n)/(n+1)

# --- main ------

for i in range(10):
  print(i, catalan(i), catalanComb(i))
