# bold 
# Fig. 4.1 and 4.2
# inputs: 0.6768 0.3456

'''

With bold play, the gambler bets her entire fortune or what she needs to reach the target, whichever is smaller. This is an optimal strategy in the unfair case; no strategy can do better. But it’s very quick! If you play this strategy, there’s a good chance that your gambling will be over after just a few games (often just onel).
'''

import matplotlib.pyplot as plt
from frange import *

linestyles = [
  '-', ':', '--', '-.', 
  (0, (3, 5, 1, 5, 1, 5)),   # dashdotdotted
  (0, (3, 5, 1, 5))   # dashdotted
]

def f(x,p):
  if x <= 0: 
    return 0
  elif x >= 1:
    return 1
  elif x <= 0.5:
    return p*f(2*x,p)
  else:
    return p + (1-p)*f(2*x-1,p)

xs = linspace(0, 1, 101)
for i, p in enumerate([0.2, 0.4, 0.5, 0.6, 0.8]):
  fs = [f(x,p) for x in xs]
  style = linestyles[i%len(linestyles)]
  plt.plot(xs, fs, label="p="+str(p), ls=style)
plt.xlabel('Fortune x')
plt.ylabel('f(x,p)')
plt.legend()
plt.title('Probs of Eventual Success')
plt.show()
