
# plotEq.py
# Fig 3.6
# input: x*x*x - x - 1
#        1 2
# input: x*math.sin(1/x)
#        -2 2

import math
import matplotlib.pyplot as plt
from frange import *

def strToFun(equ):
  def fn(x):
    return eval(equ)
  return fn

def plotEq(equ, xStart, xEnd):
  fn = strToFun(equ)
  xs = list(frange(xStart, xEnd, 0.01))
  ys = [ fn(x) for x in xs]
  plt.xlim(xStart, xEnd)
  plt.plot(xs, ys)
  plt.axhline(y=0, color='k')
  plt.axvline(x=0, color='k')
  plt.title("Equation: " + str(equ))
  plt.show()

if __name__ == "__main__":
  equ = input("x equation? ")
  xStart,xEnd = map(float, input("xStart xEnd=? ").split())
  plotEq(equ, xStart, xEnd)