# bis.py
# Fig 3.4 
# Bisection: root finding

EPS = 1E-9
MAX_ITERS = 500

import math 

def sign(x):
  if abs(x) == 0:
    return 0
  else:
    return int(x/abs(x))

def ef(x):  # roots between 0.5 and 1.5 and 2 and 3
  return math.exp(x - math.sqrt(x)) - x

def perrin(x):  # root between 1 and 2
  return x*x*x - x - 1

def bis(fn, a, b):
  if sign(fn(a)) == sign(fn(b)):
    print(f"{a} and {b} do not span a root")
    return None, 0
  else:
    return biRec(fn, a, b, 0)

def biRec(fn, a, b, iters):
  mid = (a + b)/2
  if iters > MAX_ITERS:
    print(f"Iterations exceeded", MAX_ITERS)
    return mid
  if abs(fn(mid)) < EPS:
    return mid
  elif sign(fn(a)) == sign(fn(mid)):
    # mid is an improvement on a 
    return biRec(fn, mid, b, iters+1)
  elif sign(fn(b)) == sign(fn(mid)):
    # mid is an improvement on b 
    return biRec(fn, a, mid, iters+1)

if __name__ == "__main__":
  a,b = map(float, input("a b? ").split())
  root = bis(perrin, a, b)
  # root = bis(ef, a, b)
  print(f"Root = {root:.10f}")
