
# guessTest.py
"""
  TEST simulates the result of guessing on a ranking test.

  A list of numItems items is given.
  The test taker is required to give a rank for each.
  For each item, the test taker randomly chooses a value between 0 and numItems-1.
  What is the average number of correct rankings?

  Paul Nahin,
  Digital Dice: Computational Solutions to Practical Probability Problems,
  Princeton, 2008,
  Intro p.8 and Appendix 1
"""

import random, math

NUM_ITERS = 100000

numItems = int(input("num items=? "))

totalCorrect = 0
for k in range(NUM_ITERS):
  numCorrect = 0
  term = [0]*numItems
  for j in range(numItems):
    term[j] = math.floor(numItems * random.random())

  for j in range(numItems):
    if term[j] == j:
      numCorrect += 1

  totalCorrect += numCorrect

print("Average number of correct matches:", (totalCorrect / NUM_ITERS))

