
# goldSpiral.py
# inputs: 5  or 8 
'''
Plot the golden spiral

https://en.wikipedia.org/wiki/Golden_spiral

'''
import math
from fibsLib import *
from frange import *
from matplotlib import pyplot as plt


NUM_PTS = 1000

def plotGolden(n):
  angles = linspace(0, n*math.pi, NUM_PTS)
  # Convert to (r,theta) to (x,y)
  xs = [PHI_F**(2*ang/math.pi) * math.cos(ang) for ang in angles]
  ys = [PHI_F**(2*ang/math.pi) * math.sin(ang) for ang in angles]

  plt.figure(figsize=(8, 8))
  plt.plot(xs, ys, color="blue", linewidth=2)
  plt.axis("equal")
  plt.axhline(0)
  plt.axvline(0)
  plt.title("Golden Spiral")
  plt.show()

n = float(input("n? "))
plotGolden(n)
