
# goldScatter2D.py
'''
Plot the golden spiral as a series of 2D points.

https://stackoverflow.com/questions/5837572/generate-a-random-point-within-a-circle-uniformly/50746409#50746409


https://physics.nyu.edu/grierlab/fibonacci3b/node2.html

https://extremelearning.com.au/how-to-evenly-distribute-points-on-a-sphere-more-effectively-than-the-canonical-fibonacci-lattice/

https://stackoverflow.com/questions/9600801/evenly-distributing-n-points-on-a-sphere

'''

import random, math
import matplotlib.pyplot as plt
from fibsLib import *


NUM_PTS = 1000

circle = plt.Circle((0, 0), 1, color="red", alpha=0.3)
plt.gca().add_patch(circle)

xs = [0]*NUM_PTS
ys = [0]*NUM_PTS
for i in range(NUM_PTS):  
  r = (i/NUM_PTS)**0.5 
  theta = 2*math.pi*(i*PHI_F) 
  xs[i] = r*math.cos(theta)
  ys[i] = r*math.sin(theta)

plt.scatter(xs, ys, s=10)
plt.axis('scaled')
plt.title("Golden Spiral 2D Points")
plt.show()
