
# factCompare.py 
'''
  compare running time and memory usage of
  recursive and iterative factorials
'''

import time, sys, tracemalloc
from factsLib import *

import matplotlib.pyplot as plt


sys.setrecursionlimit(10**6)
# sys.set_int_max_str_digits(0)  # for printing the result

ns = [n for n in range(10, 2000, 10)]
tms = []
mems = []

tracemalloc.start()

for n in ns:
  tracemalloc.clear_traces()
  start_time = time.time()
  factRec(n) 
  elapsedRec = time.time() - start_time
  _, peakMemRec = tracemalloc.get_traced_memory()

  tracemalloc.clear_traces()
  start_time = time.time()
  factRange(n)
  elapsedIter = time.time() - start_time
  _, peakMemIter = tracemalloc.get_traced_memory()

  tms.append(elapsedRec-elapsedIter)
  mems.append((peakMemRec, peakMemIter))
  
tracemalloc.stop()

fig, ax = plt.subplots(1, 2, figsize=(12,6))

ax[0].set_xlabel('n')
ax[0].set_ylabel('diff secs')
ax[0].plot(ns, tms) 
ax[0].set_title("Times Diffs: Rec - Iter")

memRec, memIter = zip(*mems) 
ax[1].set_xlabel('n'); ax[1].set_ylabel('bytes')
ax[1].plot(ns, memRec, label="Recursive") 
ax[1].plot(ns, memIter, label="Iterative",ls="dashed") 
ax[1].legend()
ax[1].set_title("Factorial Memory Usage")

plt.show() 
